﻿/*
VERSION:  1.0

Requires Zinc

USAGE:
	#include "functions/VOW/zincMultiSave.as"
	var file = zincMultiSave();
	#include "functions/writeExif.as"
	var image_path = "folder with spaces\\137f582e1dd12f73.png";
	var values = {artist: "merf",  tags: ["one","two"], url: "google.com"};
	var exiftool_path = "exiftool.exe";
	writeExif( image_path, values, file.save, exiftool_path ).then = function(){
		mdm.Exception.DebugWindow.trace("write finished");
	}
	
	
	#include "functions/VOW/zincSave.as"
	#include "functions/writeExif.as"
	var image_path = "folder with spaces\\137f582e1dd12f73.png";
	var values = {artist: "merf",  tags: ["one","two"], url: "google.com"};
	var exiftool_path = "exiftool.exe";
	writeExif(  image_path, values, zincSave, exiftool_path ).then = function(){
		mdm.Exception.DebugWindow.trace("write finished");
	}
*/
#include "functions/VOW.as"
function writeExif( image_path, values, zincSave, exiftool_path ){
	var prom = VOW.make();
	var appPath = mdm.Application.path;
	if( !appPath ){
		mdm.Exception.DebugWindow.trace("ERROR:  Missing Zinc");
		return VOW.make().doBreak();
	}
	if( !image_path ){
		mdm.Exception.DebugWindow.trace("ERROR:  Missing image path");
		return VOW.make().doBreak();
	}
	for(var hasValues in values)
		break;
	if( !hasValues ){
		mdm.Exception.DebugWindow.trace("WARN:  No values.  Resume program.");
		return VOW.make().keep();
	}
	if( zincSave instanceof Function === false ){
		mdm.Exception.DebugWindow.trace("ERROR:  Missing a Zinc save function");
		return VOW.make().doBreak();
	}
	if( !exiftool_path ){
		exiftool_path = "exiftool.exe";
	}
	if( exiftool_path.substr( -4 ) !== ".exe" ){
		exiftool_path = exiftool_path + ".exe";
	}
	if( image_path.indexOf(":\\") === -1 ){
		image_path = appPath + image_path;
	}
	if( exiftool_path.indexOf(":\\") === -1 ){
		exiftool_path = appPath + exiftool_path;
	}
	if( !mdm.FileSystem.fileExistsUnicode( image_path )  ){
		mdm.Exception.DebugWindow.trace("ERROR:  Image file doesn't exist at:  " + image_path);
		return VOW.make().keep();
	}
	if( !mdm.FileSystem.fileExistsUnicode( exiftool_path )  ){
		mdm.Exception.DebugWindow.trace("ERROR:  exiftool.exe doesn't exist at:  " + exiftool_path);
		return VOW.make().keep();
	}
	
	// convert tags into array  +  Remove spaces
	var tags_ary = [];
	if(  ( values.tags instanceof Object ) === true  &&  ( values.tags instanceof Array ) === false  )
	{// if:  tags is object
		for(var tag in values.tags){
			tag = tag.split(" ").join("");		// remove spaces
			if( tag ){												// ignore empty strings
				tags_ary.push( tag );
			}
		}
	}// if:  tags is object
	else if( values.tags instanceof Array === true )
	{// if:  tags is array
		var tags_str = String( values.tags );
		tags_str = tags_str.split(" ").join("");			// remove spaces
		tags_str = tags_str.split(",,").join(",");		// remove empty strings
		tags_ary = tags_str.split(",");
	}// if:  tags is array
	
	
	// write CMD
	var cmd = '';
	cmd += '"' + exiftool_path + '"';
	cmd += ' -preserve -overwrite_original_in_place';
	if( values.artist ){
		cmd += ' -creator="' + values.artist + '"';
		cmd += ' -artist="' + values.artist + '"';
		cmd += ' -XPAuthor="' + values.artist + '"';
	}
	cmd += ' -source= ';		// delete legacy "source" tags.  "CreatorWorkURL" should be used instead of "Source" because "Source" is limited to only 32 characters long.
	if( values.url )
		cmd += ' -CreatorWorkURL="' + values.url + '"';
	if( values.copyright )
		cmd += ' -copyright="' + values.copyright + '"';
	if( values.comment )
		cmd += ' -UserComment="' + values.comment + '"';
	cmd += ' -XPKeywords= ';
	if( tags_ary.length > 0 )
		cmd += ' -sep "," -keywords="' + String( tags_ary ) + '"';
	cmd += ' "' + image_path + '"';
	
	
	// save CMD script
	var fileName = "writeExif_" + Math.floor( Math.random() * 9999 ) + ".cmd";
	var cmd_path = appPath + fileName;
	var success_output = "1 image files updated";
	var saving_prom = zincSave( cmd_path, cmd );
	saving_prom.then = function(){
		// run script
		var output_str = mdm.System.execStdOut( cmd_path );
		// clean up
		if( cmd_path  &&  mdm.FileSystem.fileExistsUnicode( cmd_path ) === true  ){
			mdm.FileSystem.deleteFileUnicode( cmd_path );
		}
		// check the result
		if( output_str.indexOf(success_output) > -1 ){
			// exiftool success
			prom.keep();
		}else{
			// exiftool fail
			mdm.Exception.DebugWindow.trace("WARN:  exiftool fail?  Resume program.");
			mdm.Exception.DebugWindow.trace( output_str );
			prom.keep();
		}
	}// saving done
	
	return prom;
}// readExif()