﻿/*	VERSION:  1.0
	
	USAGE: 
	#include "functions/VOW/detectMouseMove.as"
	VOW.kept()
	.then( showAnimation )
	.then( detectMouseMove(32, 0.5) )
	.then( hide );
*/
function detectMouseMove( moveThreshold, moveTimeThreshold ){
	// default values
	var moveThreshold = moveThreshold || 32;						// in pixels
	var moveTimeThreshold = moveTimeThreshold || 0.5;		// in seconds
	
	
	
	function promise_func(){
		// 
		var prom = VOW.make();
		if( !prom )		return;		// no promise can be made;
		// 
		var reactToMouseMove = null;
		var mouseMove_interval = null;
		// detect (significant?) mouse movement
		var mouseStart_p = new flash.geom.Point( _root._xmouse, _root._ymouse );
		
		// require the mouse to move far enough
		reactToMouseMove.disable();		reactToMouseMove = null;		// remove previous mouse-move reaction
		reactToMouseMove = react.to("onMouseMove").from( Mouse );
		reactToMouseMove.then = function(){
			// check distance traveled
			var mouseEnd_p = new flash.geom.Point( _root._xmouse, _root._ymouse );
			var distance = flash.geom.Point.distance( mouseStart_p, mouseEnd_p );
			if( distance > moveThreshold ){
				reactToMouseMove.disable();		// remove previous mouse-move reaction
				clearInterval( mouseMove_interval );		mouseMove_interval = null;
				prom.keep();
			}// if distance is large enough
		}// mouse moved()
		
		// require mouse to move far enough, within a short time  (by periodically re-starting mouse measurement)
		mouseMove_interval = setInterval(function(){
			mouseStart_p = new flash.geom.Point( _root._xmouse, _root._ymouse );
		}, moveTimeThreshold*1000);
		
		// clean-up
		react.to("unload").then = stopDetectingMouse;
		
		return prom;
		
		
		
		function stopDetectingMouse(){
			clearInterval( mouseMove_interval );		mouseMove_interval = null;
			reactToMouseMove.disable();		reactToMouseMove = null;		// remove previous mouse-move reaction
		}// stopDetectingMouse()
	}// promise_func()
	
	
	
	return promise_func;
}// detectMouseMove()