﻿/*	VERSION:	1.4
1.4		Uses a more reliable way of figuring out the top-left coordinate of any movieClip
1.3		Better compatibility with certain components by prioritizing clip.width  (specifically the FileBrowser component)
1.2		Measures movieClip size based solely on the result of getBounds(),  which allows correct hit-detection with scaled movieClips
1.1		Now uses .getBounds() for compatibility with movieClips whose origin is not located at their top-left corner.

USAGE:
	#include "functions/hitClip.as"
	react.to("onDropFiles").from(dropFileEvents).then = function( evt )	{
		if(  !hitClip( {x:_root._xmouse,y:_root._ymouse}, bg )  )		return;
		
		if( !hitClip( evt.mouse, bg ) )		return;
		// do stuff
	}// onDropFiles()
	
NOTES:
	hitClip() assumes the input hit-coordinates are global, relative to _root)
	"onDropFiles" event always provides global mouse coordinates, relative to _root
*/
function getClipRect( clip, relativeTo ){
	var relativeTo = relativeTo || _root;
	
	// top-left corner
	var topLeft_p = new flash.geom.Point(0, 0);
	clip.localToGlobal( topLeft_p );
	relativeTo.globalToLocal( topLeft_p );
	var xx = topLeft_p.x;
	var yy = topLeft_p.y;
	
	if( clip.width !== undefined ){
		var ww = clip.width;
		var hh = clip.height;
		// var xx = (clip.x !== undefined) ? clip.x : clip._x;
		// var yy = (clip.y !== undefined) ? clip.y : clip._y;
		var topLeft = new flash.geom.Point(xx,yy);
		// convert  topLeft + size  =>  Rectangle
		var output_rect = new flash.geom.Rectangle( topLeft.x, topLeft.y, ww, hh );
		return output_rect;
	}
	else if( clip.getBounds ){
		var bounds = clip.getBounds( relativeTo );
		var xMin = bounds.xMin;
		var yMin = bounds.yMin;
		// var xMin = xx;
		// var yMin = yy;
		var ww = bounds.xMax - xMin;
		var hh = bounds.yMax - yMin;
		// var output_rect = new flash.geom.Rectangle( bounds.xMin, bounds.yMin, ww, hh );
		var output_rect = new flash.geom.Rectangle( xMin, yMin, ww, hh );
		return output_rect;
		// var topLeft = new flash.geom.Point( bounds.xMin, bounds.yMin );
		// var topLeft = bounds.topLeft;
		// convert  topLeft + size  =>  Rectangle
		// var output_rect = new flash.geom.Rectangle( topLeft.x, topLeft.y, ww, hh );
		// return output_rect;
	}
	else{
		// size
		var ww = clip._width;
		var hh = clip._height;
		// var xx = (clip.x !== undefined) ? clip.x : clip._x;
		// var yy = (clip.y !== undefined) ? clip.y : clip._y;
		var topLeft = new flash.geom.Point(xx,yy);
		// convert  topLeft + size  =>  Rectangle
		var output_rect = new flash.geom.Rectangle( topLeft.x, topLeft.y, ww, hh );
		return output_rect;
	}
}// getClipRect()


function hitClip( coords_p, clip ){
	var rect = getClipRect( clip, _root );
	var output = rect.containsPoint( coords_p );
	// mdm.Exception.DebugWindow.trace("hitting "+clip._name+": "+output+"   rect: "+rect);
	// mdm.Exception.DebugWindow.trace("  Touch coords: (" + coords_p.x + ", " + coords_p.y + ")");
	return output;
}// hitClip()