﻿/*
VERSION:  1.1
AUTHOR:   Humbird0
LICENSE:  Public Domain

DESCRIPTION:
  Creates a human-readable description based on a set of keywords.
  
USAGE:
  // read selected keywords_ary, and store each item in an object-list  {"key1":true, "key2":true, "key3":true}
  var tags_obj = {};
  for(var i=0; i<keywords_ary.length; i++){
    tags_obj[  keywords_ary[ i ]  ] = true;
  }
  // generate a description
  var description_txt = getDescriptionFromKeywords( tags_obj, rules_ary );
  // display this description
  console.log( description_txt );
*/


/**
* Creates a human-readable description based on a set of keywords.
* 
* @param  keywords  an object-list of keywords to evaluate  {key1:true, key2:true, key3:true}
* @param  rules     an array of rules that generate and modify the description  [{hasKeywords:["key1","key2"], replaceText:"", withText:""}]
* @return           a string description
*/
function getDescriptionFromKeywords( keywords_obj, rules_ary, startWithText ){
  // write a description, by applying each rule
  var description_txt = startWithText || "";
  for(var r=0; r<rules_ary.length; r++){
    var thisRule = rules_ary[ r ];
    var ruleApplies = true;
    var keyLen = thisRule.hasKeywords.length || 0;
    for(var k=0; k<keyLen; k++){
      var isForbidden = (thisRule.hasKeywords[k].charAt(0) === "!");
      if( isForbidden === false ){
        // No keywords  >>  this means always apply this rule
				if( thisRule.hasKeywords[k] === "" ){
					continue;
				}
				
				// This is a regular keyword, so it must be present. If this keyword is missing, then this rule should be skipped.
        if( keywords_obj[  thisRule.hasKeywords[k]  ] === undefined ){
          ruleApplies = false;
          break;// stop: for keyLen   // stop checking any more keywords
        }// if this required keyword exists
      }else{
        // if isForbidden === true
        // This is a forbidden keyword, so it must be absent. If this keyword is present, then this rule should be skipped.
        if( keywords_obj[  thisRule.hasKeywords[k].substr(1)  ] !== undefined ){
          ruleApplies = false;
          break;// stop: for keyLen   // stop checking any more keywords
        }// if this forbidden keyword is present
      }
    }// for keyLen
    //
    if( ruleApplies === false ){
      continue;// skip to next: for rules_ary   // skip this rule
    }
    // else,  ruleApplies === true
    // is this rule replacing text?
    var replaceText = thisRule.replaceText || "";
    var withText = thisRule.withText || "";
    if( replaceText ){
      // this rule is replacing text
      var hasText = ( description_txt.indexOf( replaceText ) > -1 );
      if( hasText ){
        // replaceText is found...
        // ... so replace all instances of replaceText with withText.
        description_txt = description_txt.split( replaceText ).join( withText );
      }else{
        // replaceText is missing...
        // ... so do nothing.
        continue;// skip to next: for rules_ary   // skip this rule
      }
    }else{
      // this rule is adding text
      var alreadyHasNewText = (description_txt.indexOf( withText ) > -1);
      if( alreadyHasNewText ){
        // withText already exists in description_txt...
        // ... so do nothing.
        continue;// skip to next: for rules_ary   // skip this rule
      }else{
        // withText is absent from description_txt...
        /// ... so append withText to the end of description_txt.
        description_txt += withText;       
      }
    }
  }// for each rule
  // remove ", " from the start of description_txt
  if( description_txt.indexOf(", ") === 0 )
    description_txt = description_txt.substr( 2 );
  // output
  return description_txt;
}// getDescriptionFromKeywords()