﻿/*	VERSION: 1.0

WARNING:
	MovieClips do not always fire the "unload" event when they're removed, so you may need to manually send "unload" before removing a child movieClip.

DESCRIPTION:
	This synchronizes an event between a parent movieClip and a child movieClip, so when that event fires within either movieClip, both movieClips recieve that event exactly once per fire.
	This allows the same event to be sent to and recieved from a child movieClip, without risking a bounce-back or loop.
	
	This function only needs exist in the outer movieClip.
	This function should be called for each child movieClip that you want to establish this link with.
	As always, children movieClips do not need to know about their parent movieClips, not even whether they exist.

USAGE:
	_this = this;
	#include "functions/eventSystem3.as"
	if(!_this.addListener)		AsBroadcaster.initialize( _this );
	if(!react)								var react = make_react( _this );		// param is optional
	function onUnload(){
		if( _name )
			sendEvent( "unload" );		// this will trigger react.unload()		... and trigger any external code listening for "unload" to occur here
	}// onUnload()
	#include "functions/twoWayEvent.as"
	
	twoWayEvent( "eventName", child1_mc );
	twoWayEvent( "eventName", child2_mc );
*/
function twoWayEvent( eventName, child ){
	var output = {};
	
	var reactToChild = react.to( eventName ).from( child );
	var reactToSelf = react.to( eventName );
	reactToChild.then = tellSelf;
	reactToSelf.then = tellChild;
	
	function tellSelf( evt ){
		if( child === undefined ){
			cleanup();
			break;
		}
		reactToSelf.then = null;
		_this.sendEvent( eventName, evt );
		reactToSelf.then = tellChild;
	}// tellSelf()
	
	function tellChild( evt ){
		if( child === undefined ){
			cleanup();
			break;
		}
		reactToChild.then = null;
		sendEvent( eventName, evt, child );
		reactToChild.then = tellSelf;
	}// tellChild()
	
	if(!child.addListener)		AsBroadcaster.initialize( child );
	react.to("unload").from( child ).then = cleanup;
	
	function cleanup(){
		reactToChild.disable();
		reactToSelf.disable();
		delete reactToChild;
		delete reactToSelf;
		delete tellSelf;
		delete tellChild;
	}
	
	return cleanup;
}// twoWayEvent()