﻿/*
VERSION:		2.9
2.9		Fixed:  Can copy arrays without passing in the 2nd parameter "destObj"
2.8		Change:  Can copy variables passed in as input
2.7		Fixed:  Now copies all variables stored in array objects, not just the indexed items
2.6		Fixed:  duplicating arrays now works
2.5		now skips children who reference their parent  (single-level detection to try to avoid infinite-recursion)
2.4		copyObject() now returns the cloned object
2.3		Changed emptyObject() to handle arrays properly
2.2		used "function" prefix to enable local scoping

USAGE:
	#include "functions/copyObject.as"
	var destination_var = copyObject( source_var );		// only use ONE parameter when copying variables
	... or
	copyObject( source_obj, destination_obj );
	... or
	var destination_obj = copyObject( source_obj );
	
WHAT IT'S FOR
	Copy the contents of one object into another,
	erasing the destination object's contents first.
	
WHAT IT HANDLES:
	Basic variables	(ie: string, number, boolean)
	Multi-dimensional Arrays
	Normal Objects
	BitmapData
	XMLNode
	
WHAT IT SKIPS:
	Functions
	Most Actionscript classes & components
	MovieClips
	
*/



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



function emptyObject( inputObject )
{
	if( getType(inputObject) === "array" )
	{// if:  array
		inputObject.splice( 0, inputObject.length );
	}// if:  array
	
	else
	
	{// if:  object
		for (var nam in inputObject )
			delete inputObject[nam];
	}// if:  object
}// emptyObject()



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



function getType( inputObject )
{
	var output = "";
	
	// unsupported objects to ignore
	if ( inputObject instanceof Function )
	{
		// this is a function
		output = "function";
	}
	else if ( inputObject instanceof MovieClip )
	{
		// this is a movieClip
		output = "movieClip";
	}
	
	// supported objects to handle
	else if ( inputObject instanceof Array )
	{
		// this is an array
		output = "array";
	}
	else if ( inputObject instanceof XMLNode )
	{
		// this is an object
		output = "xml";
	}
	else if ( inputObject instanceof flash.display.BitmapData )
	{
		// this is an object
		output = "bitmap";
	}
	else if ( inputObject instanceof Object )
	{
		// this is an object
		output = "object";
	}
	else
	{
		// this is a regular variable
		output = "variable";
	}
	
	return output;	// object, array, string, number, boolean
}// getType()



function copyObject( srcObj, destObj )
{
	// variables pass through untouched
	if( getType(srcObj) === "variable" ){
		destObj = srcObj;
		return srcObj;
	}
	
	if( !destObj ){
		if( getType(srcObj) === "object" ){
			var destObj = {};
		}else if( getType(srcObj) === "array" ){
			var destObj = [];
		}
	}
	emptyObject( destObj );
	if( getType(srcObj) === "array" ){
		var srcReversed = new Array( srcObj.length );		// make a new array with a pre-determined length
		// Copy indexed items AND arbitrary variables, becuase an array is technically an object  (Some RPG Maker commands add variables to them)
		for( var childName in srcObj )
			srcReversed[childName] = srcObj[childName];
	}else{
		var srcReversed = {};
		for( var childName in srcObj )
			srcReversed[childName] = srcObj[childName];
	}
	for( var childName in srcReversed )
	{
		var thisChild = srcReversed[childName];
		var childType = getType(thisChild);
		
		// skip children who reference their parents		(causes infinite recursion)
		if( thisChild === srcObj  )		continue;
		
		// handle variables
		if (childType === "variable")
		{
			destObj[childName] = thisChild;
		}
		
		// handle pictures
		if (childType === "bitmap")
		{
			// // create new object
			destObj[childName] = thisChild.clone();
		}
		
		// handle XML
		if (childType === "xml")
		{
			// // create new object
			destObj[childName] = thisChild.cloneNode(true);
		}
		
		// handle Arrays
		if (childType === "array")
		{
			// // create new array
			destObj[childName] = new Array();
			// // set dest, scan array
			copyObject( thisChild, destObj[childName] );
		}
		
		// handle Objects
		if (childType === "object")
		{
			// // create new object
			destObj[childName] = new Object();
			// // set dest, scan object
			copyObject( thisChild, destObj[childName] );
		}
			
	}// END:  for...in
	
	return destObj;
}// copyObject()



