﻿var version = 1.0;
/*
USAGE:
	#include "functions/onDropFiles.as"
	react.to("onDropFiles").then = function( evt )	{
		if( !hitClip( evt.mouse, self ) )
			return;
		
		mdm.Exception.DebugWindow.trace( evt.relativeFiles[0] );		// first file
	}// onDropFiles()
*/



if(!_this)		var _this = this;
if( !runFunc ){
	var runFunc = function( func ){
		return func.apply( _this, arguments.slice() );
	}// runFunc()
}// if:  runFunc is missing



runFunc(function(){
	// settings
	var waitDuration_ms = 33;		// 1 animation frame at 30 fps
	
	
	// allow _this to receive events
	#include "functions/eventSystem3.as"
	if(!_this.addListener)		AsBroadcaster.initialize( _this );
	if(!react)								var react = make_react( _this );		// param is optional
	
	
	// create global file-drop detector
	if( _global.ZINC_DROP_FILES === undefined ){
		var self = _global.ZINC_DROP_FILES = {};
		self.version = version;
		AsBroadcaster.initialize( self );
		mdm.Forms.MainForm.dndEnable();
		mdm.Application.onDragDrop = function( evt ){
			// wait for focus to return to this Flash program so _xmouse gets updated
			setTimeout(function(){
				evt.mouse = new flash.geom.Point( _root._xmouse, _root._ymouse );
				
				// make a list of the files, using editor-relative paths  (if all files are external, then this list will be empty)
				evt.relativeFiles = [];
				var appPath = mdm.Application.path;
				for(var f=0; f<evt.files.length; f++){
					// omit external files
					if( evt.files[f].indexOf(appPath) === -1 )		continue;
					var relativePath = evt.files[f].split( appPath ).join("");
					evt.relativeFiles.push( relativePath );
				}// for: each file
				
				sendEvent( "onDropFiles", evt, self );
			}, waitDuration_ms);
		}// onDragDrop()
	}// if:  not initialized
	
	
	// tell _this about file-drops
	react.to("onDropFiles").from( _global.ZINC_DROP_FILES ).tell( _this );
	
	// (legacy)  tell dropFileEvents about file-drops if it exists
	react.to("onDropFiles").from( _global.ZINC_DROP_FILES ).then = function( evt ){
		// use sendEvent() instead of tell() in case dropFileEvents gets created later on
		if( _this.dropFileEvents )
			sendEvent( "onDropFiles", evt, _this.dropFileEvents );
	}// _global.ZINC_DROP_FILES.onDropFiles()
});// scope
version = null;		delete version;