﻿/*	VERSION: 1.1
1.1		FIX:		Renamed "to" to "justBefore"
							No longer runs a loop for the "justBefore" index.  Runs from "from" index up to, but not including, "justBefore" index.
	
USAGE:
	#include "functions/slowLoop.as"
	progressBar.mode = "manual";
	progressBar.minimum = 0;
	progressBar.maximum = 100;
	slowLoop( 0, 10, 34, function( index ){
		// loop
		
	}, function( perc ){
		progressBar.setProgress( perc, 100 );
	} ).then = function(){
		// done
		
	};
	
	
PARAMETERS:
	slowLoop( fromNum, toNum, delayBetweenLoops_ms, loopFunc, onProgressFunc ).then = doneFunc;
	
DESCRIPTION:
	This runs a "for" loop gradually over time, then resolves a promise afterwards.
	"onProgress" function gets called before each loop to update progress.
	Maybe I should replace it with a "perc" parameter in the main loop?  The main loop could just update a progress bar instead.
*/
function slowLoop( from, justBefore, delay, runThis, onProgress ){
	if( from === undefined  ||  from >= justBefore)
		return;
	if( justBefore === undefined  ||  justBefore < 0 )
		return;
	var delay = delay || 34;
	if( !runThis )
		return;
	//
	var prom = VOW.make();
	//
	var i = from-1;
	var percScale = 100 / (justBefore-from);		// from*scale = percent
	var interval = setInterval(function(){
		if( (i+1) < justBefore ){
			// continue
			i++;
			onProgress( i*percScale );
			runThis( i );
		}else{
			// done
			clearInterval( interval );
			delete from;
			delete justBefore;
			delete delay;
			delete runThis;
			delete i;
			onProgress( 100 );
			prom.keep();
		}
	}, delay);
	//
	return prom;
}// slowLoop()