﻿function applyNameStyle( nameStyle, artist, in_fileName ){
	if( !nameStyle ){
		output_txt.text += '\n' + " applyNameStyle() is MISSING nameStyle";
		mdm.Exception.DebugWindow.trace(" applyNameStyle() is MISSING nameStyle");
		return in_fileName;
	}
	else
	{
		// if:  nameStyle
		var newFileName = '';
		var fileName = in_fileName;
		var sepAt = -1;
		var sep = "";
		
		// separator
		if( nameStyle.indexOf(" - ") > -1 ){
			sep = " - ";
		}
		else if( nameStyle.indexOf("_") > -1 ){
			sep = "_";
		}
		
		
		// artist
		if( typeof(artist) === "string"  &&  artist.length > 0 ){
			// upper artist
			if( nameStyle.indexOf("A") > -1 ){
				newFileName += artist;
			}
			// lower artist
			else if( nameStyle.indexOf("a") > -1 ){
				newFileName += artist.toLowerCase();
			}
			
			// separator
			if( artist )
				newFileName += sep;
			
			// remove artist
			fileName = in_fileName;
			if( fileName.indexOf( artist ) > -1 ){
				// try to remove artist without changing case
				fileName = fileName.split( artist ).join("");
			}// if:  contains artist name
			// if not successful, then change filename to lowercase and remove artist
			else if( fileName.toLowerCase().indexOf( artist.toLowerCase() ) > -1 ){
				// change filename to lowercase
				fileName = fileName.toLowerCase().split( artist.toLowerCase() ).join("");
			}// if:  contains artist name
		}// if:  artist
		
		// remove " _ " old custom separator
		fileName = fileName.split(" _ ").join("");
		
		// file name
		// upper name
		if( nameStyle.indexOf("F") > -1 ){
			newFileName += fileName;
		}
		// lower name
		else if( nameStyle.indexOf("f") > -1 ){
			// remove spaces
			fileName = fileName.split(" ").join("");
			//
			newFileName += fileName.toLowerCase();
		}
		
		// remove spaces
		if( sep === "_" ){
			newFileName = newFileName.split(" ").join("");
		}
		
		// replace periods
		newFileName = newFileName.split(".").join("_");
		
		// remove commas
		newFileName = newFileName.split(",").join("_");
		
		// remove aporstrophes
		newFileName = newFileName.split("'").join("");
		
		// remove duplicate separators
		if( sep ){
			newFileName = newFileName.split( sep+sep ).join( sep );
			newFileName = newFileName.split( sep+sep ).join( sep );
		}
		
		// remove multiple -- (minus minus)
		newFileName = newFileName.split("--").join("-");
		newFileName = newFileName.split("--").join("-");
		
		// remove multiple __ (underscore underscore)
		newFileName = newFileName.split("__").join("_");
		newFileName = newFileName.split("__").join("_");
		
		// remove _ (underscore) from the beginning of the filename
		if( newFileName.charAt(0) === "_" )
			newFileName = newFileName.substr( 1 );
		
		// remove _ (underscore) from the end of the filename
		if( newFileName.charAt( newFileName.length-1 ) === "_" )
			newFileName = newFileName.substr( 0, newFileName.length-1 );
		
		// remove - (minus) from the beginning of the filename
		if( newFileName.charAt(0) === "-" )
			newFileName = newFileName.substr( 1 );
		
		// remove - (minus) from the end of the filename
		if( newFileName.charAt( newFileName.length-1 ) === "-" )
			newFileName = newFileName.substr( 0, newFileName.length-1 );
		
		// 
		return newFileName;
	}// if:  there is a naming template
}// applyNameStyle()



// input:   C:\long\path\to\My File.jpeg
// output:  C:\long\path\to\artistname_myfile.jpeg
#include "program/getFileExt.as"
#include "program/getFileNameFromPath.as"
function applyNameStyleToPath( nameStyle, artist, in_filePath ){
	
	var folderPath = "";
	var fileAt = in_filePath.lastIndexOf('\\');
	if( fileAt > -1 )
		folderPath = in_filePath.substr( 0, fileAt+1 );		// C:\path\to\
	
	var ext = getFileExt( in_filePath );		// .jpeg
	
	var newFileName;
	var localImage = getFileNameFromPath( in_filePath, true );		// newFile
	newFileName = applyNameStyle( nameStyle, artist, localImage );		// artist_newFile
	
	var output = folderPath + newFileName + ext;		// C:\path\to\artist_newFile.jpeg
	return output;
}// applyNameStyleToPath()