/**
	Note:  jQuery is available to this script

	This script is divided into 4 overall sections:
		variables								// These are all of the variable declarations & explanations about what they're for.
		variable initializers		// These functions are used to populate each of the variables above.
		Main program steps			// These functions are the steps used by the main promise-chain.
		Main program						// This is the main promise-chain, spelling out the overall sequence of this script.
	
	Code execution begins with "Main program" at the bottom of this document
	"variables"  "variable initializers"  "Main program steps"  contain declarations and definitions which are all called by the  "Main program"  block
*/




// variables
	// Note:  A "submission" is a project on Inkbunny.  Each HTML page on Inkbunny displays one submission.  Their main content can be an image, comic, story, flash animation, or music.
	// Submission type flags & measurements
	var submissionIsVisible = false;	// Flag specifying whether or not any submission is being displayed on this HTML page.
	var isFlash = false;							// Flag specifying whether or not the current submission is a flash animation.
	var isMusic = false;							// Flag specifying whether or not the current submission is an audio file.
	var isComic = false;							// Flag specifying whether or not the current submission is a comic.
	var isStory = false;							// Flag specifying whether or not the current submission is a text story.
	var hasDownload = false;					// Flag specifying whether or not the current page already has a download link.
	var downloadWidth = 0;						// The width of the download tag, in pixels.  Used for the <progress> meter.

	// Data read from the HTML page  (things that need to be sanitized)
	var artistName = "";							// The name of the artist who drew the current submission.
	var downloadUrl = "";							// The dirct-download URL for the current submission's file.  (Such files are typically:  jpg, gif, png, txt, doc, swf, mp3)
	var picTitle = "";								// The title of the current submission.
	var storyText = "";								// The plain text of this submission's story, if this submission contains one.

	// injection points on the page
	var $imageArea = null;						// Html tag reference to the main content area of the page.
	var $artistNameArea = null;				// Html tag reference to the tag containing the name of the submission's artist.
	var $topArea = null;							// Html tag reference to the tag above a comic submission which normally displays the "prev" "next" links.  A download link will be added to it.
	var $bottomArea = null;						// Html tag reference to the tag where Inkbunny places its normal download link.

	// Data used to create download links
	var downloadImage_url = "images/fullsize/download.png";
	var newDownload_htm = "";					// The HTML for creating a new Download link.
	var $artistDownload = null;				// A new html fragment containing an empty <span>, which is placed next to the artist's name.  This will later contain a download link.
	// $progressTag										// A local-scope jQuery list of all <progress> tags.  Each download session generates a unique set of progress bars.
	var $downloadTags = $();					// A jQuery list of tags to place download links into.
	var $dlLinkTag = $();							// A jQuery list of all download link tags present within $downloadTags, including ones added by this extension.  These are the clickable areas of each link.
	var $dlLabel = $();								// A jQuery list of all download link label tags present within $downloadTags, including the ones added by this extension.  These are the text labels of each link.
// variables




// variable initializers
	// Submission flags & measurements
	function get_submissionIsVisible( $imageArea ){
		var hasDisplayedImage = ($imageArea.length > 0);
		// detect the "fav" buttons.  They're not displayed if no submission is shown
		var hasFavButtons = ($("#fav_block_help").length > 0);
		return hasDisplayedImage || hasFavButtons;

		// TEST
		// return true;
	}// get_submissionIsVisible()
	function get_isFlash( $imageArea ){
		// detect whether or not there are any <embed> tags on the page
		return (document.getElementsByTagName('embed').length > 0);		// 0 = false,  1 or more = true
		// return ($imageArea.find("object").length > 0);
	};
	function get_isMusic( $imageArea ){
		// return ($imageArea.find(".jwplayer").length > 0);
		// detect whether there is a music-player on the page
		return ($(".jwplayer").length > 0);
	};
	function get_isStory(){
		return ($("#storysectionpagesfoo").length > 0);
	}
	function get_isComic( $imageArea ){
		// detect whether or not the current submission is a comic
		// comic submissions always display the text:    1 of # next end    above their main image
		// var htmlText_str = $imageArea.text();								// Get all of the displayed text within the $imageArea tag.
		var htmlText_str = $("#files_area div").text();			// Get all of the displayed text within the comic navigation area.
		var hasOf = (htmlText_str.indexOf('of') > -1);			// Whether or not that text includes the word "of"
		return (hasOf);
	};
	function get_hasDownload( $bottomArea ){
		// return ($bottomArea.find("img").length > 0);
		return ($("#size_container a img").length > 0);
	};
	function get_downloadWidth( $dlLabel ){
		$dlLabel.width();
	};


	// Data read from the HTML page
	function get_artistName( $artistNameArea ){
		var $artistNameTextArea = $artistNameArea.last().contents().eq(0);
		var artistName = $artistNameTextArea.text();
		artistName = artistName.split("\t").join("");
		artistName = artistName.split("\n").join("");
		artistName = artistName.split("'s Gallery").join("");
		artistName = artistName.split("s' Gallery").join("s");
		 

		// sanitize the title
		var dirty_str = artistName;
		var $prom = new $.Deferred();		// jQuery promise
		
		// when sanitation is complete, send the results as a resolved promise
		self.port.on("onSanitize:folder", function( clean_str ){
			self.port.on("onSanitize:folder", null);		// Run only once.  Don't respond to future onSanitize events.
			$prom.resolve( clean_str );		// jQuery promise resolve
		});// onSanitize event

		// request sanitation from main.js
		self.port.emit("sanitize", {
			dirty_str: dirty_str,
			callback_str: "folder"
		});

		return $prom;										// jQuery promise monad
	};// get_artistName()
	function get_downloadUrl( isFlash, isMusic, isStory, isComic, $imageArea )
	{
		// Find the main content on the page, and return its URL
		var downloadUrl = null;
		if( isFlash ){
			// flash
			// var linkTag = $imageArea.find("a")[0];
			// target the "download" <a> link under the flash file
			var linkTag = $("#size_container a img").parent()[0];
		}else if( isMusic ){
			// audio
			// var linkTag = $imageArea.find("a")[0];
			// target the "download" <a> link under the music player
			var linkTag = $("#size_container a img").parent()[0];
		}else if( isStory ){
			// audio
			// var linkTag = $imageArea.find("a")[0];
			// target the "download" <a> link under the music player
			var linkTag = $("#size_container a img").parent()[0];
		}else if( isComic ){
			// comic
			// $imageArea = $($(".elephant_white")[1]);	// second "elephant_white" class
			// var linkTag = $imageArea.find(".widget_imageFromSubmission").first().find("a")[0];
			// target the displayed <img> image  /OR/  target the <a> tag wrapping the displayed image
			$imageArea = get_$imageArea();
			var $imgParent = $imageArea.parent();
			var href = $imgParent.attr("href");
			var linkTag = (href) ? $imageArea.parent()[0] : null;
		}else{
			// image
			// var linkTag = $imageArea.find(".widget_imageFromSubmission").first().find("a")[0];
			// target the displayed <img> image  /OR/  target the <a> tag wrapping the displayed image
			$imageArea = get_$imageArea();
			var $imgParent = $imageArea.parent();
			var href = $imgParent.attr("href");
			var linkTag = (href) ? $imageArea.parent()[0] : null;
		}


		if( !linkTag )
		{// if:  no clickable link was found
			var imgTag = $imageArea[0];
			if(imgTag !== undefined)
			{// if:  an image is displayed
				// use the image's src URL as the download link
				downloadUrl = imgTag.src;
			}// if:  an image is displayed
		}// if:  no clickable link was found
		else
		{// if:  a clickable link was found
			// use the image's link href as the download link
			downloadUrl = linkTag.href;
		}// if:  a clickable link was found
		//return downloadUrl;

		// sanitize the downloadUrl
		var dirty_str = downloadUrl;
		var $prom = new $.Deferred();		// jQuery promise
		
		// when sanitation is complete, send the results as a resolved promise
		self.port.on("onSanitize:downloadUrl", function( clean_str ){
			self.port.on("onSanitize:downloadUrl", null);		// Run only once.  Don't respond to future onSanitize events.
			$prom.resolve( clean_str );		// jQuery promise resolver
		});// onSanitize event

		// request sanitation from main.js
		self.port.emit("sanitize", {
			dirty_str: dirty_str,
			callback_str: "downloadUrl"
		});

		return $prom;										// jQuery promise monad
	};// get_downloadUrl()
	function get_picTitle()
	{
		// get the title of the submission
		// var title = $(".weasel").first().prev().text();
		// use a very-specific selector to target the H1 tag displayed above the submission
		var title = $("#pictop.content table.pooltable tbody tbody td h1").text();

		// sanitize the title
		var dirty_str = title;
		var $prom = new $.Deferred();		// jQuery promise
		
		// when sanitation is complete, send the results as a resolved promise
		self.port.on("onSanitize:picTitle", function( clean_str ){
			self.port.on("onSanitize:picTitle", null);		// Run only once.  Don't respond to future onSanitize events.
			$prom.resolve( clean_str );		// jQuery promise resolver
		});// onSanitize event

		// request sanitation from main.js
		self.port.emit("sanitize", {
			dirty_str: dirty_str,
			callback_str: "picTitle"
		});

		return $prom;										// jQuery promise monad
	};// get_picTitle()
	function get_storyText()
	{
		// read the story text as raw HTML
		// var story_html = $("#storysectionbar").children(0).html();
		var story_html = $("#storysectionbar").children(0).html();

		// convert the HTML into plain text
		var story_str = story_html;
		// omit the " at the very beginning
		if(story_str.charAt(0) == '"'){
			story_str = story_str.substr(1);
		}
		// omit the " at the very end
		if(story_str.charAt(story_str.length-1) == '"'){
			story_str = story_str.substr(0, story_str.length-1);
		}
		// Remove " at the beginning of paragraphs, if present
		story_str.split('<br>"').join('<br>');
		// Remove " at the end of paragraphs, if present
		story_str.split('"<br>').join('<br>');
		// convert <br> into standard windows carriage-returns
		story_str.split('<br>').join('\r\n');
		// convert non-breaking-spaces into regular spaces
		story_str.split('$nbsp;').join(' ');
		// remove <em> tags  (plain text cannot display italic text)
		story_str.split('<em>').join('');
		story_str.split('</em>').join('');


		// sanitize the story text
		var dirty_str = story_str;
		var $prom = new $.Deferred();		// jQuery promise
		
		// when sanitation is complete, send the results as a resolved promise
		self.port.on("onSanitize:storyText", function( clean_str ){
			self.port.on("onSanitize:storyText", null);		// Run only once.  Don't respond to future onSanitize events.
			$prom.resolve( clean_str );		// jQuery promise resolver
		});// onSanitize event

		// request sanitation from main.js
		self.port.emit("sanitize", {
			dirty_str: dirty_str,
			callback_str: "storyText"
		});

		return $prom;										// jQuery promise monad
	}// get_storyText()


	// injection points on the page
	function get_$imageArea(){
		// return $(".elephant_white").first();
		// return $("div.elephant_white.magicboxParent div.content.magicboxParent div").first();
		var imgTag = $("#magicbox.shadowedimage");
		if(imgTag.length === 0){
			imgTag = $("div.content.magicboxParent div.widget_imageFromSubmission img.shadowedimage");
		}
		return imgTag;
	};
	function get_$artistNameArea(){
		// isolate the element containing the artist's name, by using a super-specific selector
		// return $(".weasel").first();
		return $("#pictop.content table.pooltable tbody tbody a");
	};
	function get_$topArea(){
		// return $(".elephant_white").first().find(".content > div");
		return $("#pictop.content table.pooltable tbody tbody a").last();
	};
	function get_$bottomArea(){
		// return $("#size_container").first();
		return $("#fav_block_help").last();
	};


	// Data used to create download links
	function make_$artistDownload(){
		// creates a new HTML fragment
		return $("<span></span>");
	};
	function make_$newProgressTag(){
		return $($('<progress></progress>'));
	};
	function make_$downloadTags(){
		// This jQuery list is initially empty.  Element references get added to it later.
		return $();
	};
	function get_$dlLinkTag( $downloadTags ){
		return $downloadTags.find("img").parent();
	};
	function get_$dlLabel( $dlLinkTag ){
		return $dlLinkTag.find("span");
	};
// variable initializers




// Main program steps
	// getPageData() reads data from the page and sanitizes it
	function getPageData( $artistNameArea, $imageArea, isFlash, isMusic, isStory, isComic )
	{
		var $prom = new $.Deferred();		// jQuery promise
		
		get_artistName( $artistNameArea )
		.then(function( sanitized_artistName ){
			artistName = sanitized_artistName;
			start_get_downloadUrl();
		});// get_artistName()

		function start_get_downloadUrl(){
			get_downloadUrl( isFlash, isMusic, isStory, isComic, $imageArea )
			.then(function( sanitized_downloadUrl ){
				downloadUrl = sanitized_downloadUrl;
				start_get_picTitle();
			});// get_downloadUrl()
		}// start_get_downloadUrl()

		function start_get_picTitle(){
			get_picTitle()
			.then(function( sanitized_picTitle ){
				picTitle = sanitized_picTitle;
				start_get_storyText();
			});// get_picTitle()
		}// start_get_picTitle()

		function start_get_storyText(){
			if(isStory){
				get_storyText()
				.then(function( sanitized_storyText ){
					storyText = sanitized_storyText;
					done();
				});// get_storyText()
			}else{
				storyText = "";
				done();
			}
		}// start_get_storyText()

		function done(){
			$prom.resolve();		// jQuery promise resolver
		}// finished_getPageData()

		return $prom;										// jQuery promise monad
	}// getPageData()



	function addDownloadLinks()
	{
		// This code is only called after "artistName"  "downloadUrl"  "picTitle"  have all been populated and sanitized first by getPageData()
		// "artistName"  "downloadUrl"  "picTitle"  are the only variables derived from on-page data.

		// detect whether or not this submission is visible  (A submission may be hidden because of:  Not being logged in,  or due to the user's content filter)
		submissionIsVisible = get_submissionIsVisible( $imageArea );
		if( submissionIsVisible )
		{// if:  submission is shown
			if( downloadUrl )
			{// if:  The content can be downloaded
				// prepare to add download links
				$downloadTags = make_$downloadTags();
				
				// add a clickable "download" link under the submission  (if neccessary)
				$bottomArea = get_$bottomArea();							// target the existing tag under the submission's main image
				hasDownload = get_hasDownload($bottomArea);		// determine whether or not the page already has a download link
				// Create a <a> link using "downloadUrl" which is sanitized before addDownloadLinks() is called
				newDownload_htm = '<a target="_blank" href="'+downloadUrl+'" style="border: 0px; color: #888888;"><img src="'+downloadImage_url+'" style="margin-left: 3px; border: 0px;"> <span style="border-bottom: 1px dotted #aaaaaa;">download</span></a>';

				// Add a download link is it's missing  (some submissions already have one)
				if(hasDownload === false)
				{// if:  a download link doesn't already exist
					// Add an InkBunny-style download link
					$bottomArea.append( $(newDownload_htm) );
					hasDownload = true;
				}// if:  a download link doesn't already exist
				$downloadTags = $downloadTags.add( $bottomArea );

				// add a download link next to the artist's name at the top
				$artistDownload = make_$artistDownload();
				$artistNameArea.last().append( $artistDownload );
				$artistDownload.html(" &nbsp; "+newDownload_htm);
				$downloadTags = $downloadTags.add( $artistDownload );

				// Populate the label of all download links  (including existing ones)
				$dlLinkTag = get_$dlLinkTag( $downloadTags );
				$dlLabel = get_$dlLabel( $dlLinkTag );
				$dlLabel.text( "download" );
				

				// download the file to the artist's folder
				function downloadFile(){
					// abort if critical information is missing
					if(!downloadUrl)		return;
					if(!artistName)			return;

					// visual interface
					$dlLabel.text( "download" );
					downloadWidth = get_downloadWidth( $dlLabel );
					var $progressTag;		// this needs to be local, because each download link gets their own progress tag
					var showProgress = function(){
						// create a progress bar
						var $newProgressTag = make_$newProgressTag();
						$dlLabel.width( downloadWidth );
						$dlLabel.html( $newProgressTag );
						$progressTag = $dlLabel.find("progress");		// target ALL progress tags that were placed
						$progressTag.attr("max", "100");
					}// showProgress()
					var changeProgress = function( perc ){
						if($progressTag !== undefined){
							$progressTag.attr("value", perc);
						}
					}// changeProgress()
					var showText = function( msg_str ){
						$dlLabel.html('');		// remove progress tag
						$dlLabel.text( msg_str );
					}// showText()
					var disableProgress = function(){
						// clean-up event listeners
						self.port.on("showProgress", null );
						self.port.on("changeProgress", null );
						self.port.on("showText", null );
						self.port.on("done", null );
					}// disableProgress()

					// request a download
					self.port.emit("download", {
						url: downloadUrl,			// downloadUrl is sanitized by getPageData() before this code is run
						artist: artistName,		// artistName is sanitized by getPageData() before this code is run
						title: picTitle,			// picTitle is sanitized by getPageData() before this code is run
						storyText: storyText	// storyText is sanitized by getPageData() before this code is run.  Non-story submissions explicitly set this to an empty string.
					});
					// react to download progress
					self.port.on("showProgress", function(){		showProgress()	});
					self.port.on("changeProgress", function(perc){		changeProgress(perc)	});
					self.port.on("showText", function(msg_str){		showText(msg_str)	});
					self.port.on("done", function(){		disableProgress()	});
					return false;
				}// downloadFile()


				$dlLinkTag.click(downloadFile);




				// If the file was already downloaded, then say so
				self.port.emit("checkAlreadyDownloaded", {
					url: downloadUrl,
					artist: artistName
				});// checkAlreadyDownloaded() event
				self.port.on("alreadyDownloaded", function( hasFile ){
					if(hasFile){
						$dlLabel.text("This file already exists");
					}
				});// alreadyDownloaded() event




				// auto-download the image  (optional)
				setTimeout( function(){
					// Ask main.js whether or not autoDownload is enabled
					// // response
					self.port.on("autoDownloadPref", function( autoDownloadEnabled ){
						self.port.on("autoDownloadPref", null);
						if(autoDownloadEnabled)			downloadFile();
					});
					// // request
					self.port.emit("getAutoDownloadPref");// find out whether the user has chosen to automatically download images
				}, 1 );

			}// if:  The content can be downloaded
		}// if:  submission is shown
	}// addDownloadLinks()
// Main program steps




// Main program
	// prepare to get page data
	$artistNameArea = get_$artistNameArea();
	$imageArea = get_$imageArea();
	isFlash = get_isFlash( $imageArea );
	isMusic = get_isMusic( $imageArea );
	isStory = get_isStory();
	isComic = get_isComic( $imageArea );

	// MAIN SCRIPT
	// getPageData() retrieves on-page data and sanitizes it before running addDownloadLinks()
	getPageData( $artistNameArea, $imageArea, isFlash, isMusic, isStory, isComic )		// populates & sanitizes:  artistName, downloadUrl, picTitle
	.then( addDownloadLinks );																							// add download links to the page using sanitized artistName, downloadUrl, picTitle

// Main program
