/**
	Note:  jQuery is available to this script
	
	This script is divided into 4 overall sections:
		variables								// These are all of the variable declarations & explanations about what they're for.
		variable initializers		// These functions are used to populate each of the variables above.
		Main program steps			// These functions are the steps used by the main promise-chain.
		Main program						// This is the main promise-chain, spelling out the overall sequence of this script.

	Each of these sections are enclosed within redundant {} for easy code-folding in programs such as SublimeText
*/



// variables
	var $artistNameArea = null;		// Injection point for the "Open folder" link.
	var $folderArea = null;			// An html fragment containing a <span> tag.
	var $folderLink = null;			// Html tag reference to the newly-created "Open folder" link.
	var text = "";							// Text to display within the open-folder link

	// Data read from the HTML page  (things that need to be sanitized)
	var artistName = "";				// The name of the artist who drew the current submission.
// variables






// variable initializers
	function get_$artistNameArea(){
		// isolate the element containing the artist's name, by using a super-specific selector
		return $("#pictop.content table.pooltable tbody tbody a");
	};
	function make_$folderArea(){
		var grayStyle = 'style="color: #babdb6;"';
		return $( $('<span '+grayStyle+'></span>') );
		//return $("#pictop.content table.pooltable tbody tbody a span").last();
	}
	function make_$folderArea_html( text ){
		var js = 'javascript:void(0);';
		var style = 'style="border-bottom: 1px dotted; border-color: #8ae234; color: #8ae234;"';
		return ' &nbsp; [<a href="'+js+'" '+style+'>'+text+'</a>]';
	};
	function get_$folderLink( $folderArea ){
		return $folderArea.find("a");
	};
	function get_artistName( $artistNameArea ){
		var $artistNameTextArea = $artistNameArea.last().contents().eq(0);
		var artistName = $artistNameTextArea.text();
		artistName = artistName.split("\t").join("");
		artistName = artistName.split("\n").join("");
		artistName = artistName.split("'s Gallery").join("");
		artistName = artistName.split("s' Gallery").join("s");
		console.log(artistName);

		// sanitize the title
		var dirty_str = artistName;
		var $prom = new $.Deferred();		// jQuery promise
		
		// when sanitation is complete, send the results as a resolved promise
		self.port.on("onSanitize:folder", function( clean_str ){
			self.port.on("onSanitize:folder", null);		// Run only once.  Don't respond to future onSanitize events.
			$prom.resolve( clean_str );		// jQuery promise resolve
		});// onSanitize event

		// request sanitation from main.js
		self.port.emit("sanitize", {
			dirty_str: dirty_str,
			callback_str: "folder"
		});

		return $prom;										// jQuery promise monad
	};// get_artistName()
// variable initializers




// Main program steps
	function getPageData( $artistNameArea )
	{
		var $prom = new $.Deferred();		// jQuery promise
		
		get_artistName( $artistNameArea )
		.then(function( sanitized_artistName ){
			artistName = sanitized_artistName;
			done();
		});// get_artistName()

		function done(){
			$prom.resolve();							// jQuery promise resolver
		}// finished_getPageData()

		return $prom;										// jQuery promise monad
	}// getPageData()




	function addFolderLink()
	{
		// create folder link
		text = 'Open folder';
		$folderArea = make_$folderArea();										// Create a <span> fragment
		$folderArea.html( make_$folderArea_html( text ) );		// Create HTML:  [Open folder]
		$artistNameArea.last().append( $folderArea );							// Put the  [Open folder]  HTML into the  <span>  fragment
		$folderLink = get_$folderLink( $folderArea );				// Get a reference to the <a> of the newly created HTML

		// react to click
		$folderLink.click(function(){
			$folderLink.text( text );

			var showText = function( msg_str ){
				$folderLink.text( msg_str );
			}// showText()
			var cleanUp = function(){
				self.port.on("showFolderText", null );
				self.port.on("folderDone", null );
			}// cleanUp()
			
			// open folder
			self.port.emit("openFolder", {
				artist: artistName
			});
			self.port.on("showFolderText", function(msg_str){		showText(msg_str)	});
			self.port.on("folderDone", function(){		cleanUp()	});
			
			return false;
		});// click()

	}// addFolderLink()
// Main program steps




// Main program
	// prepare to get page data
	$artistNameArea = get_$artistNameArea();

	// MAIN SCRIPT
	getPageData( $artistNameArea )		// populate:  artistName
	.then( addFolderLink );						// Add an [Open folder] link next to the artist's name
// Main program
