var {Cu, Cc, Ci} = require("chrome");
var Downloads = Cu.import("resource://gre/modules/Downloads.jsm").Downloads;				// Enable downloading files
// var OS = Cu.import("resource://gre/modules/osfile.jsm").OS;													// Enable creating paths in order to download files
const {TextEncoder, OS} = Cu.import("resource://gre/modules/osfile.jsm", {});
var Promise = Cu.import("resource://gre/modules/Promise.jsm").Promise;							// Enable promises
var Task = Cu.import("resource://gre/modules/Task.jsm").Task;												// Enable synchronous pausing for promise calls
var FileUtils = Cu.import("resource://gre/modules/FileUtils.jsm").FileUtils;				// Enable opening folders
var ParserUtils = Cc["@mozilla.org/parserutils;1"].getService(Ci.nsIParserUtils);		// Enable sanitizing strings read from HTML
var pageMod = require("sdk/page-mod");						// Detect when an Inkbunny submission page loads
var self = require("sdk/self");										// Enable access to the extension's own internal folder
var prefs = require('sdk/simple-prefs').prefs;		// Enable access to the extension's preferences



// run submissionPage.js when the user views a submission on InkBunny
pageMod.PageMod({
	include: "https://inkbunny.net/submissionview.php?id=*",
	contentScriptFile: [
		"./jquery.js",
		"./submissionPageDownload.js",
		"./submissionPageFolder.js"
	],
	onAttach: onPageLoad
});



// after the page loads, do this
function onPageLoad( worker ){
	worker.port.on("openFolder", function(params){
		{// resolve parameters & data
			// artist

			// TEST
			//if( !prefs.downloadFolder )		prefs.downloadFolder = "C:\\test";
			
			// abort if "artist" parameter is missing
			if( !params.artist )
			{// if:  undefined or falsey
				error( "Artist is undefined" );
				return false;
			}	// if:  undefined or falsey

			// sanitize the artist name
			var artist = sanitizeFilename(params.artist);

			// abort if "downloadFolder" setting is not set
			if( !prefs.downloadFolder )
			{// if:  undefined or falsey
				error( "I don't know where look for this folder.  Set up InkBunny Downloader's preferences" );
				return false;
			}// if:  undefined or falsey

			var artistFolder = OS.Path.normalize( OS.Path.join(prefs.downloadFolder, artist) );
		}// resolve parameters & data


		// main steps
		createArtistFolder( artistFolder )
		.then( ifFolder )
		.then( openFolder )
		.then( done, error );
		


		function ifFolder()
		{
			return new Promise(function( resume, abort )
			{
				var scanFolder = OS.File.stat;

				scanFolder( artistFolder ).then(
					checkFolder,	// stat scan success
					abort					// stat scan fail
				);// scanFolder()

				function checkFolder( stat ){
					// folder = resume,  file = abort
					if (stat.isDir)	resume() || abort();
				}// checkFolder()
			});// promise obj
		}// ifFolder()


		function openFolder(){
			var fileObject = new FileUtils.File( artistFolder );
			fileObject.reveal();
		}// openFolder()


		function done(){
			worker.port.emit("folderDone");
		}// done()


		function error( msg ){
			worker.port.emit("showFolderText", "ERROR:  "+msg );
			worker.port.emit("folderDone");
			return false;
		}// error()
	});// openFolder() event



	worker.port.on("download", function(params)
	{
		{// resolve parameters & data
			// url
			// artist
			// title
			// storyText
			// showProgress()
			// changeProgress( perc )
			// showText( text )
			// downloadDone()

			// TEST
			// if( !prefs.downloadFolder )		prefs.downloadFolder = "C:\\test";
			
			if(params.url === undefined){
				error( "URL is undefined" );
				return false;
			}	
			if(!params.artist){
				error( "Artist is undefined" );
				return false;
			}
			// sanitize the artist name
			var artist = sanitizeFilename(params.artist);
			


			if(!prefs.downloadFolder){
				error( "I don't know where to download this.  Set up InkBunny Downloader's preferences" );
				return false;
			}
			// if(prefs.downloadFolder === undefined)		prefs.downloadFolder = "C:\\test";
			
			var dlThis = params.url;
			var toHere = OS.Path.normalize( OS.Path.join(prefs.downloadFolder, artist) );
			var url_ary =  params.url.split("/");
			var asThis = url_ary[ url_ary.length-1 ];
		}// resolve parameters & data


		
		// main steps
		createArtistFolder( toHere )
		.then( downloadStory )
		.then( ensureFileDoesntExist )
		.then( downloadFile )
		.then( done, error );
		


		// download story text
		function downloadStory(){
			return Task.spawn( function(){
				var fileContents_str = params.storyText;
				if(fileContents_str.length > 0)
				{// if:  there's story-text to save
					// figure out where this .txt file will go
					var artistFolder = toHere;
					// invent a filename for the story's plain text
					var fileName = asThis;
					// remove normal image extension
					var endAt = fileName.lastIndexOf(".");
					if(endAt > -1){
						fileName = fileName.substr(0, endAt);
					}
					// append ".txt" to the filename
					fileName += ".txt";
					filename = sanitizeFilename( fileName );
					// write this .txt file...
					// ... wait for the file to finish being written
					var filePath_str = OS.Path.join( artistFolder, fileName );
					var encoder = new TextEncoder();
					var fileContent_array = encoder.encode( fileContents_str );
					yield OS.File.writeAtomic( filePath_str , fileContent_array, {tmpPath: filePath_str+".tmp", noOverwrite: true});
				}// if:  there's story-text to save
				else
				{// if:  there is NO story text to save
					// do nothing  &  continue the overall promise chain
					return;
				}// if:  there is NO story text to save
			});	// download task
		}// downloadStory()


		// check if this download already exists within the artist folder
		function ensureFileDoesntExist(){
			// if yes
				// abort download
			return new Promise(function( resume, abort ){
				var destFile = OS.Path.join(toHere, asThis);
				OS.File.exists(  destFile  )
				.then( function( fileExists ){
					if(fileExists)	abort( "This file already exists" );
					else						resume();
				});		// true = abort,  false = resume
			});// promise
		}// ensureFileDoesntExist()


		// download the file
		function downloadFile(){
			return Task.spawn( function(){
				// start download
				worker.port.emit("showProgress");
				var thisDownload = yield Downloads.createDownload({
					source: dlThis,
					target: OS.Path.join(toHere, asThis)
				});

				thisDownload.onchange = function(){
					console.log( thisDownload.progress +'%' );
					worker.port.emit("changeProgress", thisDownload.progress);
				}// onChange()
				
				// wait for the download to finish
				yield thisDownload.start();

				// download done
				worker.port.emit("showText",  "Finished downloading!" );
			});	// download task
		}// downloadFile()


		function done(){
			worker.port.emit("done");
		}// done()


		function error( msg ){
			worker.port.emit("showText", msg );
			worker.port.emit("done");
			return false;
		}// error()
	});// download() event
	


	worker.port.on("checkAlreadyDownloaded", function(params)
	{
		{// resolve parameters & data
			// url
			// artist
			
			if(params.url === undefined){
				// error( "URL is undefined" );
				return false;
			}	
			if(!params.artist){
				// error( "Artist is undefined" );
				return false;
			}
			// sanitize the URL
			var url = sanitize( params.url );
			// sanitize the artist name
			var artist = sanitize( sanitizeFilename(params.artist) );

			if(!prefs.downloadFolder){
				// error( "I don't know where to download this.  Set up InkBunny Downloader's preferences" );
				return false;
			}
			// if(prefs.downloadFolder === undefined)		prefs.downloadFolder = "C:\\test";
			
			var dlThis = url;
			var toHere = OS.Path.normalize( OS.Path.join(prefs.downloadFolder, artist) );
			var url_ary = url.split("/");
			var asThis = url_ary[ url_ary.length-1 ];
		}// resolve parameters & data


		ensureFileExists().then(function( result ){
			worker.port.emit("alreadyDownloaded", result);
		});


		// check if this download already exists within the artist folder
		function ensureFileExists(){
			var destFile = OS.Path.join(toHere, asThis);
			return OS.File.exists(  destFile  );
		}// ensureFileExists()

		function error(){
			// does nothing
		}// error()
	});// checkAlreadyDownloaded() event


	
	// Workers can ask whether or not auto-download is enabled
	var autoDownload = (prefs.autoDownload===true);
	worker.port.on("getAutoDownloadPref", function(){
		worker.port.emit("autoDownloadPref", autoDownload);
	});// find out whether the user has chosen to automatically download images




	{// shared functions
		// create artist folder,  ignore existing
		function createArtistFolder( toHere ){
			return OS.File.makeDir( toHere, {
				ignoreExisting: true
			});
		}// createArtistFolder()

		
		function sanitizeFilename( value ){
			value = value.split("..\\").join("");
			value = value.split("../").join("");
			value = value.split("\\").join("");
			value = value.split("/").join("");
			value = value.split(":").join("");
			value = value.split("*").join("");
			value = value.split("?").join("");
			value = value.split("<").join("");
			value = value.split(">").join("");
			value = value.split("|").join("");
			value = value.split(" ").join("_");
			value = value.split('"').join("'");
			return value;
		}// sanitizeFilename()


		function sanitize( dirty_str ){
			return ParserUtils.convertToPlainText( dirty_str, Ci.nsIDocumentEncoder.OutputRaw, 0 );
		}// sanitize()

		worker.port.on("sanitize", function( params ){
			var callback_str = params.callback_str;
			var dirty_str = params.dirty_str;
			var clean_str = sanitize( dirty_str );
			worker.port.emit("onSanitize:"+callback_str, clean_str);		// emits onSanitize:callback_str, so that only the caller receives the result
		});// sanitize event


	}// shared functions
}// onPageLoad()