﻿/**
 * This detects when right-click is pressed and when it's released.
 * Zinc is required to disable Flash's default contextal menus.
 *
 * @example
 * // returns undefined
 * #include "functions/detectRightClick.as"
 * react.to("press").from( DETECT_RIGHT_CLICK ).then = function(){
 * 	
 * }// press right-click()
 * 
 * react.to("release").from( DETECT_RIGHT_CLICK ).then = function(){
 * 	
 * }// release right-click()
 * 
 * @author Humbird0 <humbird0@gmail.com>
 * @license Creative Commons Attribution 4.0 License
 * @date (2023-12-29)
 * @version 1.8
*/
var version = 1.0;


if(!_this)		var _this = this;
if( !runFunc ){
	var runFunc = function( func ){
		return func.apply( _this, arguments.slice() );
	}// runFunc()
}// if:  runFunc is missing
runFunc(function(){
	// if: DETECT_RIGHT_CLICK already exists with a version higher or the same as this one,  then there's no need to create DETECT_RIGHT_CLICK
	if( version  <  _global.DETECT_RIGHT_CLICK.version )
		return;
	// else
	
	// replace older versions
	_global.DETECT_RIGHT_CLICK.unload();		// run clean-up
	delete _global.DETECT_RIGHT_CLICK;
	
	// create this version
	var self = _global.DETECT_RIGHT_CLICK = {};
	AsBroadcaster.initialize( self );
	self.version = version;
	var isPressed = false;
	var wasPressed = false;
	
	
	// loop
	var interval = setInterval(function(){
		isPressed = Key.isDown(2);
		//
		if( isPressed===true && wasPressed===false ){
			sendEvent( "press", {}, self );
		}
		else if( isPressed===false && wasPressed===true ){
			sendEvent( "release", {}, self );
		}
		//
		wasPressed = isPressed;
	}, 33);// loop()
	
	
	// react to "unload" from _root
	_root.addListener( self );
	self.unload = function(){
		_root.removeListener( self );		// clean-up
		clearInterval( interval );
	}// unload()
	
	
});// scope()


version = null;		delete version;